﻿Imports System.Data.SqlClient
Imports CrystalDecisions.CrystalReports.Engine
Imports CrystalDecisions.Shared
Public Class frmPendingIssue

    Dim rpt As New rptPendingIssue()
    Dim deptDs, issuStockReqDs As New DataSet
    Dim deptDa, issuStockReqDa As SqlDataAdapter
    Dim deptCodeArray(500) As String
    Private Sub frmPendingApproval_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            Call Db_Connection()
            issuStockReqDs.Reset()
            sql = "SELECT convert(varchar,A.SRQ_DATE, 103) AS DATE, A.SRQ_ITEMCODE, A.SRQ_QTY, A.SRQ_APROVEQTY, A.SRQ_ISSUEDQTY, (A.SRQ_APROVEQTY - A.SRQ_ISSUEDQTY)AS PENDING, B.USR_EMPNAME, (E.USR_EMPNAME) AS APRVBY, C.DEPT_DEPTNAME,D.ITM_ITEMDESC FROM STOCK_REQUEST AS A LEFT JOIN USER_MASTER AS B ON B.USR_EMPID=A.SRQ_REQUESTBY LEFT JOIN DEPARTMENT AS C ON C.DEPT_DEPTID = B.USR_DEPTID LEFT JOIN ITEMS AS D ON D.ITM_ITEMCODE=A.SRQ_ITEMCODE LEFT JOIN USER_MASTER AS E ON E.USR_EMPID=A.SRQ_APRVBY WHERE A.SRQ_STATUS = 2 AND A.IS_DELETE=0 AND A.SRQ_APROVEQTY <> A.SRQ_ISSUEDQTY"
            issuStockReqDa = New SqlDataAdapter(sql, Mycn)
            issuStockReqDa.Fill(issuStockReqDs, DBNAME)

            rpt.SetDataSource(issuStockReqDs.Tables(DBNAME))

            Dim objCompany As TextObject = DirectCast(rpt.ReportDefinition.Sections("Section2").ReportObjects("txtrptCompany"), TextObject)
            objCompany.Text = LGNCOMPNAME
            Dim objAddress As TextObject = DirectCast(rpt.ReportDefinition.Sections("Section2").ReportObjects("txtrptAddress"), TextObject)
            objAddress.Text = LGNCMPADDRESS
            CrystalReportViewer1.ReportSource = rpt
            LoadDepartment()
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub

    Private Sub btnGetDetails_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetDetails.Click
        Try
            Dim deptCode As String

            If cmbDepartment.SelectedIndex = -1 Then
                deptCode = ""
            Else
                deptCode = "AND C.DEPT_DEPTID = '" & deptCodeArray(cmbDepartment.SelectedIndex) & "'"
            End If

            issuStockReqDs.Reset()
            sql = "SELECT convert(varchar,A.SRQ_DATE, 103) AS DATE, A.SRQ_ITEMCODE, A.SRQ_QTY, A.SRQ_APROVEQTY, A.SRQ_ISSUEDQTY, (A.SRQ_APROVEQTY - A.SRQ_ISSUEDQTY)AS PENDING, B.USR_EMPNAME, (E.USR_EMPNAME) AS APRVBY, C.DEPT_DEPTNAME, D.ITM_ITEMDESC FROM STOCK_REQUEST AS A LEFT JOIN USER_MASTER AS B ON B.USR_EMPID=A.SRQ_REQUESTBY LEFT JOIN DEPARTMENT AS C ON C.DEPT_DEPTID = B.USR_DEPTID LEFT JOIN ITEMS AS D ON D.ITM_ITEMCODE=A.SRQ_ITEMCODE LEFT JOIN USER_MASTER AS E ON E.USR_EMPID=A.SRQ_APRVBY WHERE A.SRQ_STATUS = 2 AND A.IS_DELETE=0 AND A.SRQ_APROVEQTY <> A.SRQ_ISSUEDQTY " & deptCode & " AND A.SRQ_DATE BETWEEN '" & dtpFromDate.Value.ToString("MM/dd/yyyy") & "' AND '" & dtpToDate.Value.ToString("MM/dd/yyyy") & "' "
            issuStockReqDa = New SqlDataAdapter(sql, Mycn)
            issuStockReqDa.Fill(issuStockReqDs, DBNAME)

            rpt.SetDataSource(issuStockReqDs.Tables(DBNAME))

            CrystalReportViewer1.ReportSource = rpt
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub


    Private Sub LoadDepartment()

        Try

            'LOAD DEPARTMENT
            sql = " SELECT DEPT_DEPTID, DEPT_DEPTNAME, CREATED_DATE FROM DEPARTMENT WHERE IS_DELETE = 0 "
            deptDa = New SqlDataAdapter(sql, Mycn)
            deptDa.Fill(deptDs, DBNAME)
            Dim rowCount = deptDs.Tables(DBNAME).Rows.Count
            cmbDepartment.Items.Clear()
            For i = 0 To rowCount - 1
                deptCodeArray(i) = deptDs.Tables(DBNAME).Rows(i).Item(0)
                cmbDepartment.Items.Add(deptDs.Tables(DBNAME).Rows(i).Item(1))
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub

End Class